IF OBJECT_ID('P_INTEGRA_CONC_TEF_ENV_VENDA') IS NOT NULL
BEGIN
	DROP PROCEDURE P_INTEGRA_CONC_TEF_ENV_VENDA
END

GO

CREATE PROCEDURE P_INTEGRA_CONC_TEF_ENV_VENDA
AS
BEGIN

SET NOCOUNT OFF

IF OBJECT_ID('INTEGRA_CONC_TEF_ENV_VENDA') IS NULL
BEGIN
	RETURN
END

DECLARE @EXISTE_PENDENCIA INT
SET @EXISTE_PENDENCIA = (SELECT COUNT(0) FROM RC_CONC_PDV_VD_TEF_ENVIO_PENDENCIA)

WHILE @EXISTE_PENDENCIA > 0 
BEGIN

	DECLARE @CD_CTR INT,@CD_VD INT,@CD_EMP INT,@CD_FILIAL INT

	DECLARE RS_PENDENTES CURSOR SCROLL_LOCKS FOR
	SELECT TOP 1000 CD_CTR,CD_VD,CD_EMP,CD_FILIAL FROM RC_CONC_PDV_VD_TEF_ENVIO_PENDENCIA ORDER BY DT_CAD 
	FOR UPDATE

	OPEN RS_PENDENTES

	FETCH NEXT FROM RS_PENDENTES INTO @CD_CTR,@CD_VD,@CD_EMP,@CD_FILIAL

	WHILE @@FETCH_STATUS = 0
	BEGIN

		INSERT INTO INTEGRA_CONC_TEF_ENV_VENDA
		(
		CAMPO_LIVRE,AUTORIZACAO,COD_ESTABELECIMENTO,COD_LOJA,COD_VENDA,DATA_VENDA,NSU,PLANO
		,PRODUTO
		,REDE,VALOR
		,STATUS_CONCILIACAO
		)
		
		SELECT
		CHAVE,CAST(NR_AUTORIZACAO AS BIGINT),CD_ESTABELECIMENTO,CD_FILIAL,CD_VD,DT_VD,CAST(NR_NSU AS BIGINT),PARC
		,CASE TP_ADM WHEN 0  THEN 'C' WHEN 2 THEN 'C' WHEN 1 THEN 'D' WHEN 3 THEN 'D' ELSE 'N' END
		,CD_REDE,VLR_CARTAO
		,0
		
		FROM
		RC_CONC_PDV_VD_TEF
		
		WHERE
		CD_EMP = @CD_EMP 
		AND CD_FILIAL = @CD_FILIAL
		AND CD_VD = @CD_VD
		AND CD_CTR = @CD_CTR

		DELETE FROM RC_CONC_PDV_VD_TEF_ENVIO_PENDENCIA WHERE CURRENT OF RS_PENDENTES


		FETCH NEXT FROM RS_PENDENTES INTO @CD_CTR,@CD_VD,@CD_EMP,@CD_FILIAL

	END

	CLOSE RS_PENDENTES
	DEALLOCATE RS_PENDENTES

	SET @EXISTE_PENDENCIA = (SELECT COUNT(0) FROM RC_CONC_PDV_VD_TEF_ENVIO_PENDENCIA)

END

SET NOCOUNT ON

END
